<?php
/* --------------------------------------------------------------
   NorthernIrelandVatIdValidator.php 2024-06-03
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2024 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Core\VatValidation\App\Validators;

/**
 * Class NorthernIrelandVatIdValidator
 *
 * @package Gambio\Core\VatValidation\App\Validators
 */
class NorthernIrelandVatIdValidator implements ManualVatIdValidator
{
    /**
     * @inheritDoc
     */
    public function validatedCountryIsoCode(): string
    {
        return 'xi';
    }
    
    
    /**
     * @inheritDoc
     */
    public function validateVatId(string $vatId): bool
    {
        return preg_match("/^xi[0-9]{9}$/", strtolower($vatId)) === 1
               || preg_match("/^xi[0-9]{12}$/", strtolower($vatId)) === 1
               || preg_match("/^xi(?:gd|ha)[0-9]{3}$/", strtolower($vatId)) === 1;
    }
}